#include "includes.h"

/****************************************************************************************
 *      Timer0_Init
 * ܣ8λʱ0ʼ,ÿ1usʱ11*250=250us
 * ڲ
 *           
****************************************************************************************/
void Timer0_Init(void)
{
	_CWDT();
	OPTR  = OPTR_Prescale_SEL_T0|OPTR_Prescale_DIV_16;		//	ԤƵ64M/4/16
	T0CTL = T0CLK_SEL_SCLK;									//	SCLKΪʱԴ
	T0 = 5;
	T0IF = 0;
	T0IE = 1;
}

/****************************************************************************************
 *      Timer1_Init
 * ܣ16λʱ1ʼ,ʹPP2 PP1ؼ	1*500=500us
 * ڲ
 *           
****************************************************************************************/
void Timer1_Init(void)
{
	T1CTL2 = T1CLK_SEL_SCLK|T1CLK_Prescale_DIV_8;	//	32m/4/8
	T1H=0;
	T1L=0;
	PWMMODE = 1;	//ʹ
	PP2=0x01;		//500-1
	PP1=0xF4-1;
	T1ON = 1;		//T1ʱ
	T1IF = 0;
	T1IE = 1;
}

/****************************************************************************************
 *      Timer2_Init
 * ܣ16λʱ2ʼ,T4T2һ;T2ʹPP60-1T4ʹPP61-1;ؼ	2.5*400=1000us
 * ڲ
 *           
****************************************************************************************/
void Timer2_Init(void)
{
	T2CTL0 = T2CLK_Prescale1_DIV_16|T2CLK_Prescale2_DIV_10;	//	64m/16/10
	T2CTL1 = TIMER2_UP_UPOverflow|T2CLK_SEL_SCLK;
	T2H=0;
	T2L=0;
	PP60H=0x01;		//400-1
	PP60L=0x90-1;
	T2ON = 1;		//T2ʱ
	T2IF = 0;
	T2IE = 1;
}

/****************************************************************************************
 *      Timer3_Init
 * ܣ16λʱ3ʼ,T3T7һ;T3ʹT3RE-1T7ʹT7RE;ؼ	2.5*400=1000us
 * ڲ
 *           
****************************************************************************************/
void Timer3_Init(void)
{

	T3CTL = TIMER3_Reload_enable|T3CLK_SEL_SCLK|T3CLK_Prescale_DIV_8;	//	64m/8
	T3H=0;
	T3L=0;
	T3REH=0x07;		//2000-1
	T3REL=0xCF;
	T3ON = 1;		//T3ʱ
	T3IF = 0;
	T3IE = 1;
}

/****************************************************************************************
 *      Timer5_Init
 * ܣ16λʱ5ʼ,T5T6һ;T5ʹPP70-1T6ʹPP71-1;ؼ	2.5*400=1000us
 * ڲ
 *           
****************************************************************************************/
void Timer5_Init(void)
{
	T5CTL0 = T5CLK_Prescale1_DIV_16|T5CLK_Prescale2_DIV_10;	//	64m/16/10
	T5CTL1 = TIMER5_UP_UPOverflow|T5CLK_SEL_SCLK;
	T5H=0;
	T5L=0;
	PP70H=0x01;		//400-1
	PP70L=0x90-1;
	T5ON = 1;		//T5ʱ
	T5IF = 0;
	T5IE = 1;
}

/****************************************************************************************
 *      Timer8_Init
 * ܣ16λʱ8ʼ,T8T9һ;T8ʹPP3T9ʹPP4;ؼ	2.5*400=1000us
 * ڲ
 *           
****************************************************************************************/
void Timer8_Init(void)
{
	T8CTL  = T8CLK_Prescale1_DIV_16|T8CLK_Prescale2_DIV_10;	//	64m/16/10
	T8CTL1 = T8CLK_SEL_SCLK;
	T8H=0;
	T8L=0;
	PP3H=0x01;		//400-1
	PP3L=0x90-1;
	T8IF = 0;
	T8IE = 1;
	T8ON = 1;		//T8ʱ
//	while(!T8IF)
//	_CWDT();
//	_NOP();_NOP();_NOP();
//	T8ON=0;
//	T8IF=0;
}

/****************************************************************************************
 *      Timer10_Init
 * ܣ16λʱ8ʼ,T10ʹPP5	ؼ	2.5*400=1000us
 * ڲ
 *           
****************************************************************************************/
void Timer10_Init(void)
{
	T10CTL0  = T10CLK_Prescale1_DIV_16|T10CLK_Prescale2_DIV_10|T10CLK_SEL_SCLK;	//	64m/16/10
	T10CTL1  = TIMER10_UP_UPOverflow;
	T10H=0;
	T10L=0;
	PP5H=0x01;		//400-1
	PP5L=0x90-1;
	T10ON = 1;		//T10ʱ
	T10IF = 0;
	T10IE = 1;
}
